/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.configuration;

import com.cumulocity.opcua.client.gateway.platform.repository.AlarmRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.QueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.aggregate.AlarmAggregators;
import com.cumulocity.opcua.client.gateway.platform.repository.aggregate.DataAggregateScheduler;
import com.cumulocity.opcua.client.gateway.platform.repository.aggregate.DataAggregator;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;

@Configuration
public class DataAggregateConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DataAggregateConfiguration.class);
    @Value(value="${gateway.mappingExecution.http.failureAlarmFixedDelay:15}")
    private long httpPostFailureAlarmFixedDelay;
    @Value(value="${gateway.mappingExecution.http.failureAlarmAggregate:true}")
    private boolean httpPostFailureAlarmAggregate;
    @Autowired
    private TaskScheduler taskScheduler;
    @Autowired
    private AlarmRepository alarmRepository;

    @Bean
    public DataAggregator<AlarmRepresentation> httpPostFailureAlarmAggregate() {
        if (this.httpPostFailureAlarmAggregate) {
            return AlarmAggregators.withActualCountInFragment((String)"actualCount", (long)this.httpPostFailureAlarmFixedDelay);
        }
        return AlarmAggregators.noAggregate();
    }

    @Bean
    public DataAggregateScheduler<AlarmRepresentation> httpPostFailureAlarmAggregateScheduler() {
        return new DataAggregateScheduler(this.httpPostFailureAlarmFixedDelay, this.httpPostFailureAlarmAggregate(), this.taskScheduler, (QueuedRepository)this.alarmRepository);
    }
}

