/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.configuration;

import java.util.Arrays;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigurationImportSelector;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.shell.SpringShellAutoConfiguration;
import org.springframework.shell.jcommander.JCommanderParameterResolverAutoConfiguration;
import org.springframework.shell.jline.JLineShellAutoConfiguration;
import org.springframework.shell.legacy.LegacyAdapterAutoConfiguration;
import org.springframework.shell.standard.StandardAPIAutoConfiguration;
import org.springframework.shell.standard.commands.StandardCommandsAutoConfiguration;

@Configuration
public class AutoConfigurationSelectorExcludingShell
extends AutoConfigurationImportSelector {
    protected Set<String> getExclusions(AnnotationMetadata metadata, AnnotationAttributes attributes) {
        Boolean shellEnabled = (Boolean)this.getEnvironment().getProperty("ssh.shell.enable", Boolean.class);
        Set exclusions = super.getExclusions(metadata, attributes);
        if (!Boolean.TRUE.equals(shellEnabled)) {
            exclusions.addAll(Arrays.asList(JLineShellAutoConfiguration.class.getName(), SpringShellAutoConfiguration.class.getName(), JCommanderParameterResolverAutoConfiguration.class.getName(), LegacyAdapterAutoConfiguration.class.getName(), StandardAPIAutoConfiguration.class.getName(), StandardCommandsAutoConfiguration.class.getName()));
        }
        return exclusions;
    }
}

