/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.bootstrap.service;

import com.cumulocity.model.ID;
import com.cumulocity.model.authentication.jwt.ErrorListener;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.bootstrap.model.JWTAvailableEvent;
import com.cumulocity.opcua.client.gateway.bootstrap.service.BootstrapService;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.jmx.ServerMonitoringMBean;
import com.cumulocity.opcua.client.gateway.platform.factory.IdentityFactory;
import com.cumulocity.opcua.client.gateway.platform.factory.ManagedObjectFactory;
import com.cumulocity.opcua.client.gateway.platform.repository.IdentityRepository;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.identity.ExternalIDRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.option.SystemOptionApi;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"platformFactoryThinEdge"})
@ConditionalOnProperty(value={"gateway.thinEdge.enabled"}, havingValue="true", matchIfMissing=false)
public class BootstrapServiceThinEdge
extends BootstrapService
implements InitializingBean,
ErrorListener {
    private static final Logger log = LoggerFactory.getLogger(BootstrapServiceThinEdge.class);
    @Value(value="${gateway.thinEdge.mqttServerURL}")
    private String mqttServerUrl;
    @Value(value="${gateway.thinEdge.deviceId}")
    private String thinEdgeDeviceId;

    @Autowired
    public BootstrapServiceThinEdge(ServerMonitoringMBean mbean, GatewayGeneralConfiguration configuration, ApplicationEventPublisher eventPublisher, IdentityRepository identityRepository, InventoryRepository inventoryRepository, SystemOptionApi systemOptionApi) {
        super(mbean, configuration, eventPublisher, identityRepository, inventoryRepository, systemOptionApi);
    }

    public void onError(ErrorListener.ErrorCode errorCode, String errorMessage) {
        log.error(errorMessage);
        System.exit(0);
    }

    public void startJWTProvider() {
        log.info("start JWT provider...");
        this.eventPublisher.publishEvent((Object)new JWTAvailableEvent());
    }

    protected void onInvalidCredentials() {
        log.warn("Invalid device credentials detected!");
    }

    protected ManagedObjectRepresentation createDevice(ID deviceId) {
        Optional externalIDRepresentationThinEdge = this.identityRepository.get(IdentityFactory.createID((String)this.thinEdgeDeviceId));
        if (externalIDRepresentationThinEdge.isEmpty()) {
            log.error("ThinEdge managed object not found! Shutting down gateway ...");
            System.exit(1);
        }
        GId thinEdgeId = ((ExternalIDRepresentation)externalIDRepresentationThinEdge.get()).getManagedObject().getId();
        log.debug("ThinEdge manged object found: " + String.valueOf(thinEdgeId));
        ManagedObjectRepresentation deviceMO = this.inventoryRepository.createChildDevice(ManagedObjectFactory.create((String)this.configuration.getGatewayName()), thinEdgeId);
        log.info("Device created with ID: {}", (Object)deviceMO.getId().getValue());
        this.identityRepository.create(deviceId, deviceMO.getId());
        return deviceMO;
    }
}

