/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.addressspace.service;

import c8y.ua.Node;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.gateway.addressspace.service.synchronizer.AddressSpaceDataStoreSynchronizer;
import com.cumulocity.opcua.client.gateway.addressspace.service.synchronizer.IterativeDataStoreSynchronizer;
import com.cumulocity.opcua.client.gateway.datastore.DataStore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class AddressSpaceDataStoreService {
    private static final Logger log = LoggerFactory.getLogger(AddressSpaceDataStoreService.class);
    static final String SCANNED_ADDRESS_SPACE_SERVERS_COLLECTION = "scannedAddressSpaceServers";
    private final DataStore dataStore;
    private AddressSpaceDataStoreSynchronizer addressSpaceDataStoreSynchronizer = new IterativeDataStoreSynchronizer();

    @Autowired
    public AddressSpaceDataStoreService(@Qualifier(value="addressSpaceFileDataStore") DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public List<Node> syncAndStoreAddressSpace(List<Node> scannedAddressSpaceNodes, Node startNodeWithNsu, String serverId) {
        if (NodeIds.isRootFolderNodeId((String)startNodeWithNsu.getNodeId())) {
            log.info("Storing full address space to data store for server {}", (Object)serverId);
            this.dataStore.store(SCANNED_ADDRESS_SPACE_SERVERS_COLLECTION, serverId, (Serializable)((Object)scannedAddressSpaceNodes), 0L);
        } else {
            Optional localAddressSpaceNodes = this.fetchFromDataStore(serverId);
            if (!localAddressSpaceNodes.isPresent()) {
                log.info("Storing partial address space to data store from start node {} for server {}", (Object)startNodeWithNsu.getNodeId(), (Object)serverId);
                this.dataStore.store(SCANNED_ADDRESS_SPACE_SERVERS_COLLECTION, serverId, (Serializable)((Object)scannedAddressSpaceNodes), 0L);
            } else {
                log.info("Starting synchronization of local address space for sub-tree of {} for server {}", (Object)startNodeWithNsu.getNodeId(), (Object)serverId);
                List syncedAddressSpace = this.addressSpaceDataStoreSynchronizer.syncAddressSpace((List)localAddressSpaceNodes.get(), scannedAddressSpaceNodes, startNodeWithNsu);
                log.info("Storing full synchronized address space to data store for server {}", (Object)serverId);
                this.dataStore.store(SCANNED_ADDRESS_SPACE_SERVERS_COLLECTION, serverId, (Serializable)((Object)syncedAddressSpace), 0L);
            }
        }
        return scannedAddressSpaceNodes;
    }

    public Optional<List<Node>> fetchFromDataStore(String serverId) {
        Optional addressSpace = this.dataStore.get(SCANNED_ADDRESS_SPACE_SERVERS_COLLECTION, serverId);
        if (addressSpace.isPresent()) {
            log.info("Return address space from data store for server {}", (Object)serverId);
            return Optional.of((List)addressSpace.get());
        }
        log.info("Data store does not contain address space for server with managed object ID {}", (Object)serverId);
        return Optional.empty();
    }

    public void storeAddressSpace(List<Node> addressSpaceNodes, String serverId) {
        Optional localAddressSpaceNodes = this.fetchFromDataStore(serverId);
        if (!localAddressSpaceNodes.isPresent()) {
            log.info("Storing address space nodes to data store for server {}", (Object)serverId);
            this.dataStore.store(SCANNED_ADDRESS_SPACE_SERVERS_COLLECTION, serverId, (Serializable)((Object)addressSpaceNodes), 0L);
        } else {
            ConcurrentHashMap<String, Node> localAddressSpaceMap = new ConcurrentHashMap<String, Node>();
            for (Node localNode : (List)localAddressSpaceNodes.get()) {
                localAddressSpaceMap.put(localNode.getNodeId(), localNode);
            }
            for (Node newNode : addressSpaceNodes) {
                localAddressSpaceMap.put(newNode.getNodeId(), newNode);
            }
            ArrayList mergedAddressSpace = new ArrayList(localAddressSpaceMap.values());
            this.dataStore.store(SCANNED_ADDRESS_SPACE_SERVERS_COLLECTION, serverId, (Serializable)mergedAddressSpace, 0L);
        }
    }

    public void updateNodeInAddressSpace(Node node, String serverId) {
        String nodeId = node.getNodeId();
        Optional localAddressSpaceNodesMaybe = this.fetchFromDataStore(serverId);
        if (localAddressSpaceNodesMaybe.isPresent()) {
            List localAddressSpaceNodes = (List)localAddressSpaceNodesMaybe.get();
            for (int i = 0; i < localAddressSpaceNodes.size(); ++i) {
                Node localNode = (Node)localAddressSpaceNodes.get(i);
                if (!nodeId.equals(localNode.getNodeId())) continue;
                localAddressSpaceNodes.set(i, node);
                break;
            }
            this.dataStore.store(SCANNED_ADDRESS_SPACE_SERVERS_COLLECTION, serverId, (Serializable)((Object)localAddressSpaceNodes), 0L);
        }
    }

    public void deleteNodeFromAddressSpace(String nodeIdWithNsUri, String serverId) {
        Optional localAddressSpaceNodesMaybe = this.fetchFromDataStore(serverId);
        if (localAddressSpaceNodesMaybe.isPresent()) {
            List localAddressSpaceNodes = (List)localAddressSpaceNodesMaybe.get();
            for (int i = 0; i < localAddressSpaceNodes.size(); ++i) {
                Node localNode = (Node)localAddressSpaceNodes.get(i);
                if (!nodeIdWithNsUri.equals(localNode.getNodeId())) continue;
                localAddressSpaceNodes.remove(i);
                break;
            }
            this.dataStore.store(SCANNED_ADDRESS_SPACE_SERVERS_COLLECTION, serverId, (Serializable)((Object)localAddressSpaceNodes), 0L);
        }
    }
}

