/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway;

import c8y.ua.Node;
import com.cumulocity.opcua.client.Nodes;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.addressspace.service.AddressSpaceDataStoreService;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AddressSpaceScanner {
    private static final Logger log = LoggerFactory.getLogger(AddressSpaceScanner.class);
    private final AddressSpaceDataStoreService addressSpaceDataStoreService;
    private final Map<String, Object> locks = new ConcurrentHashMap();

    @Autowired
    public AddressSpaceScanner(AddressSpaceDataStoreService addressSpaceDataStoreService) {
        this.addressSpaceDataStoreService = addressSpaceDataStoreService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> scan(OpcuaClient client, String serverId, boolean isForced, boolean quickScan) throws OpcuaClientException {
        Object object = this.acquireLockForServer(serverId);
        synchronized (object) {
            if (!isForced) {
                try {
                    Optional addressSpaceFromDataStore = this.addressSpaceDataStoreService.fetchFromDataStore(serverId);
                    if (addressSpaceFromDataStore.isPresent()) {
                        return (List)addressSpaceFromDataStore.get();
                    }
                }
                catch (Exception e) {
                    log.error("Exception occurred during address space scan, triggering forced scan", (Throwable)e);
                    return this.forcedScan(client, serverId, Node.builder().nodeId(Identifiers.RootFolder.toString()).build(), quickScan);
                }
            }
            return this.forcedScan(client, serverId, Node.builder().nodeId(Identifiers.RootFolder.toString()).build(), quickScan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> scan(OpcuaClient client, String serverId, Node startNode, boolean quickScan) throws OpcuaClientException {
        Object object = this.acquireLockForServer(serverId);
        synchronized (object) {
            return this.forcedScan(client, serverId, startNode, quickScan);
        }
    }

    private List<Node> forcedScan(OpcuaClient client, String serverId, Node startNode, boolean quickScan) throws OpcuaClientException {
        log.info("Scan address space starting from node {} for server {}, light scan: {}", new Object[]{startNode.getNodeId(), serverId, quickScan});
        List addressSpaceNodes = client.scan(startNode, quickScan);
        try {
            addressSpaceNodes.forEach(node -> Nodes.useNsUriForNode((Node)node, (NamespaceTable)client.getNamespaceTable()));
            Nodes.useNsUriForNode((Node)startNode, (NamespaceTable)client.getNamespaceTable());
            addressSpaceNodes = this.addressSpaceDataStoreService.syncAndStoreAddressSpace(addressSpaceNodes, startNode, serverId);
            log.info("Address space scanned and stored to data store for server {}", (Object)serverId);
        }
        catch (Throwable e) {
            log.warn("Unable to store address space into local database. Accessing to address space will require a full rescan.", e);
        }
        return addressSpaceNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> scanReverse(OpcuaClient client, String serverId, Node startNode) throws OpcuaClientException {
        Object object = this.acquireLockForServer(serverId);
        synchronized (object) {
            List addressSpaceNodes = client.scanReverse(startNode);
            addressSpaceNodes.forEach(node -> Nodes.useNsUriForNode((Node)node, (NamespaceTable)client.getNamespaceTable()));
            this.storeAncestorNodes(addressSpaceNodes, serverId);
            return addressSpaceNodes;
        }
    }

    private void storeAncestorNodes(List<Node> addressSpaceNodes, String serverId) {
        if (addressSpaceNodes.size() > 1) {
            ArrayList<Node> ancestorList = new ArrayList<Node>();
            ancestorList.addAll(addressSpaceNodes.subList(1, addressSpaceNodes.size()));
            this.addressSpaceDataStoreService.storeAddressSpace(ancestorList, serverId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object acquireLockForServer(String serverId) {
        Map map = this.locks;
        synchronized (map) {
            if (this.locks.containsKey(serverId)) {
                return this.locks.get(serverId);
            }
            Object lock = new Object();
            this.locks.put(serverId, lock);
            return lock;
        }
    }
}

